local super = require "TableColumn"

BalanceBarColumn = super:new()

local defaults = {
    max = 100,
}

local nilDefaults = {
    'value', 'value2', 'paint', 'paint2',
}

local getterNames = {'max', 'value', 'value2', 'paint', 'paint2'}

local inspectorInfo = {
    {'number', {'max'}, 'Max'},
    {'KeyArtifact', {'value'}, 'Left Value'},
    {'KeyArtifact', {'value2'}, 'Right Value'},
    {'Color', {'getPaint:setPaint', custom = 'hasExplicitPaint:'}, 'Left Color'},
    {'Color', {'getPaint2:setPaint2', custom = 'hasExplicitPaint2:'}, 'Right Color'},
}

function BalanceBarColumn:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    self.stamp = BalanceBarStamp
    self.getterNames = getterNames
    self.inspectorInfo = inspectorInfo
    
    return self
end

function BalanceBarColumn:unarchived()
    local dataset = self:getDataset()
    if dataset then
        if self:getProperty('value') == nil and self:getProperty('value2') == nil then
            local field1 = dataset:pickField('number')
            if field1 then
                local field2 = dataset:pickField('number', { field1 })
                if field2 then
                    self:setProperty('value', KeyArtifact:new(field1))
                    self:setProperty('value2', KeyArtifact:new(field2))
                    self:setTitle(field1 .. '/' .. field2)
                end
            end
        end
    end
    super.unarchived(self)
end

function BalanceBarColumn:drawCell(canvas, rect, max, value1, value2, paint1, paint2)
    rect = rect:insetXY(0, rect:height() / 6)
    local parent = self:getParent()
    local defaultPaint1, defaultPaint2 = parent:getAccentPaint(), parent:getAccentPaint2()
    BalanceBarStamp(canvas, rect, max, value1, value2, paint1 or defaultPaint1, paint2 or defaultPaint2)
end

function BalanceBarColumn:getPaint()
    return self:getProperty('paint') or self:getParent():getAccentPaint()
end

function BalanceBarColumn:getPaint2()
    return self:getProperty('paint2') or self:getParent():getAccentPaint2()
end

function BalanceBarColumn:setPaint2(value)
    self:setProperty('paint2', value)
end

function BalanceBarColumn:hasExplicitPaint2()
    return self:getProperty('paint2') ~= nil
end

return BalanceBarColumn
